from __future__ import unicode_literals
import logging

from ...base.car import Car


LOGGER = logging.getLogger(__name__)


class RightechCar(Car):

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['_id']

    @classmethod
    def extract_color(cls, raw_data):
        raise NotImplementedError

    @classmethod
    def extract_fuel(cls, raw_data):
        return raw_data['processedState']['calculatedFuel'][0]['percent']

    @classmethod
    def extract_lat(cls, raw_data):
        return raw_data['state']['lat']

    @classmethod
    def extract_lon(cls, raw_data):
        return raw_data['state']['lon']

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['vehicleModel']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['name']

    @classmethod
    def format_plate_number(cls, plate_number):
        plate_number = plate_number.split('_')[0]
        return super(RightechCar, cls).format_plate_number(plate_number)

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        raise NotImplementedError

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        raise NotImplementedError

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
