from __future__ import unicode_literals
import logging

from ...base.config import FeedConfig
from ...base.service import Feed


LOGGER = logging.getLogger(__name__)


class RightechFeedConfig(FeedConfig):

    api_login = None
    api_password = None
    api_url = 'https://app.rightech.io/api/v1/objects'
    api_token_url = 'https://app.rightech.io/api/v1/auth/token'


class RightechFeed(Feed):

    operator = None
    CarClass = None
    ConfigClass = None

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._api_token = None

    @property
    def request_url(self):
        return self.cfg.api_url

    @property
    def request_headers(self):
        headers = {
            'Autorization': 'Bearer {}'.format(self._api_token),
        }
        return headers

    def startup(self, *args, **kwargs):  # pylint: disable=arguments-differ
        super().startup(*args, **kwargs)
        self._api_token = self._get_token()

    def _get_token(self):
        data = {
            'login': self.cfg.api_login,
            'password': self.cfg.api_password,
        }
        response = self._request(method='POST', url=self.cfg.api_token_url, json=data)
        token = response.json()['token']
        return token

    def _extract_feed(self, response):
        data = response.json()
        feed = [car for car in data if car.get('status') == 'available']
        return feed
