# coding: utf-8
from __future__ import unicode_literals
import logging

from ..base.car import Car


LOGGER = logging.getLogger(__name__)


class GreenGoCar(Car):

    _COLOR_MAP = {
        'blue': Car.COLOR.BLUE,
        'silver': Car.COLOR.GRAY,
        'white': Car.COLOR.WHITE,
        'yellow': Car.COLOR.YELLOW,
    }

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['vehicle_id']

    @classmethod
    def extract_color(cls, raw_data):
        return cls._map_color(raw_data['color'].lower())

    @classmethod
    def extract_fuel(cls, raw_data):
        return float(raw_data['battery_level'])

    @classmethod
    def extract_lat(cls, raw_data):
        return float(raw_data['gps_lat'])

    @classmethod
    def extract_lon(cls, raw_data):
        return float(raw_data['gps_long'])

    @classmethod
    def extract_model(cls, raw_data):
        return '{} {}'.format(raw_data['make'], raw_data['model'])

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['plate_number']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        return 20

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        return 80

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
