from __future__ import unicode_literals
import logging

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import GreenGoCar


LOGGER = logging.getLogger(__name__)


class GreenGoFeedConfig(FeedConfig):
    api_key = 'qbwJQLKeEwDIgpCC6j3bA4MI'
    api_url = ('https://www.greengo.hu/gp_api.php?APIFunction=getVehicleList&lang=EN&apikey={}'
               .format(api_key))


class GreenGoFeed(Feed):

    operator = operators.GREENGO
    CarClass = GreenGoCar
    ConfigClass = GreenGoFeedConfig

    @property
    def request_url(self):
        return self.cfg.api_url

    def _extract_feed(self, response):
        feed = response.json()
        return feed
