# coding: utf-8
from __future__ import unicode_literals
import logging

from cars.aggregator.static_data import car_models
from ..base.car import Car


LOGGER = logging.getLogger(__name__)


class RentmeeCar(Car):

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['ID']

    @classmethod
    def extract_color(cls, raw_data):
        return Car.COLOR.GRAY.value

    @classmethod
    def extract_fuel(cls, raw_data):
        fuel_liters = float(raw_data['FUEL'])
        estimated_fuel_level = fuel_liters / 43 * 100  # Solaris has 43 l tank capacity.
        estimated_fuel_level = min(estimated_fuel_level, 100.0)
        return estimated_fuel_level

    @classmethod
    def extract_lat(cls, raw_data):
        return float(raw_data['LAT'])

    @classmethod
    def extract_lon(cls, raw_data):
        return float(raw_data['LON'])

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['MODEL']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return None

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        model = cls.extract_normalized_model(raw_data)
        if model == car_models.RAVON_R2.short_name:
            parking_tariff = 1.0
        else:
            parking_tariff = 1.5
        return parking_tariff

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        model = cls.extract_normalized_model(raw_data)
        if model == car_models.RAVON_R2.short_name:
            usage_tariff = 5.0
        else:
            usage_tariff = 7.0
        return usage_tariff

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
