from __future__ import unicode_literals
import logging

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import RentmeeCar


LOGGER = logging.getLogger(__name__)


class RentmeeFeedConfig(FeedConfig):
    api_url = 'https://rentmee.club/version3/public/car_location.cfm?format=json'


class RentmeeFeed(Feed):

    operator = operators.RENTMEE
    CarClass = RentmeeCar
    ConfigClass = RentmeeFeedConfig

    @property
    def request_url(self):
        return self.cfg.api_url

    def _extract_feed(self, response):
        data = response.json()
        feed = data['CARS']
        return feed
