from ..base.car import Car


class YandexDriveCar(Car):

    @classmethod
    def extract_local_id(self, raw_data):
        return raw_data['id']

    @classmethod
    def extract_color(cls, raw_data):
        return Car.COLOR.WHITE.value

    @classmethod
    def extract_discount(cls, raw_data):
        return 0.0

    @classmethod
    def extract_fuel(cls, raw_data):
        return raw_data['telematics_state']['fuel_level']

    @classmethod
    def extract_lat(cls, raw_data):
        return raw_data['location']['lat']

    @classmethod
    def extract_lon(cls, raw_data):
        return raw_data['location']['lon']

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['model']['code']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['number']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        return raw_data['cost_per_minute']['carsharing_parking']

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        return raw_data['cost_per_minute']['carsharing_ride']

    @classmethod
    def extract_transmission(cls, raw_data):
        return Car.TRANSMISSION.AUTOMATIC.value
