import logging

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import YandexDriveCar


LOGGER = logging.getLogger(__name__)


class YandexDriveFeedConfig(FeedConfig):
    api_url = 'http://carsharing.n.yandex.ru/api/admin/v1/cars-transport-feed/'


class YandexDriveFeed(Feed):

    operator = operators.YANDEX_DRIVE
    CarClass = YandexDriveCar
    ConfigClass = YandexDriveFeedConfig

    tick_interval = '* * * * * */10'

    @property
    def request_url(self):
        return self.cfg.api_url

    def _extract_feed(self, response):
        data = response.json()
        feed = data['cars']
        return feed
