# coding: utf-8
from __future__ import unicode_literals
from ..base.car import Car


class YouDriveCar(Car):

    _COLOR_MAP = {
        'неизвестно': Car.COLOR.UNDEFINED,
        'белая': Car.COLOR.WHITE,
        'белый': Car.COLOR.WHITE,
        'белый+черный': Car.COLOR.BLACK_WHITE,
        'белый/черный': Car.COLOR.BLACK_WHITE,
        'белый / черный': Car.COLOR.BLACK_WHITE,
        'желтый': Car.COLOR.YELLOW,
        'желтый / черный': Car.COLOR.YELLOW,
        'красный': Car.COLOR.RED,
        'мокрый асфальт / черный': Car.COLOR.BLACK,
        'серый': Car.COLOR.GRAY,
        'серый/черный': Car.COLOR.GRAY,
        'серый металик': Car.COLOR.GRAY,
        'черный': Car.COLOR.BLACK,
        'черный/белый': Car.COLOR.BLACK_WHITE,
        'черный красный': Car.COLOR.BLACK,
    }

    _TRANSMISSION_MAP = {
        'Автомат': Car.TRANSMISSION.AUTOMATIC,
        'Робот / Секвентальная': Car.TRANSMISSION.ROBOT,
    }

    @classmethod
    def extract_local_id(self, raw_data):
        return raw_data['car_id']

    @classmethod
    def extract_color(cls, raw_data):
        return cls._map_color(raw_data['color'])

    @classmethod
    def extract_discount(cls, raw_data):
        return float(raw_data['discount']) / 100

    @classmethod
    def extract_fuel(cls, raw_data):
        return raw_data['fuel']

    @classmethod
    def extract_lat(cls, raw_data):
        return raw_data['latitude']

    @classmethod
    def extract_lon(cls, raw_data):
        return raw_data['longitude']

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['model']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return None

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        return float(raw_data['tariff']['parking']) / 100

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        return float(raw_data['tariff']['usage']) / 100

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls._map_transmission(raw_data['transmission'])
