import logging

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import YouDriveCar


LOGGER = logging.getLogger(__name__)


class YouDriveFeedConfig(FeedConfig):
    api_url = 'https://youdrive.today/yandexinfo'


class YouDriveFeed(Feed):

    operator = operators.YOUDRIVE
    CarClass = YouDriveCar
    ConfigClass = YouDriveFeedConfig

    tick_interval = '* * * * * */10'

    @property
    def request_url(self):
        return self.cfg.api_url

    def _extract_feed(self, response):
        data = response.json()
        feed = data['cars']
        return feed
