import base64
import furl
import logging
import os
import uuid


from cars.core.util import import_class
import cars.settings
from ..models import AutocodeFinePhoto


LOGGER = logging.getLogger(__name__)


class FinePhotosManager:

    def __init__(self, *, mds_bucket_name, images_access_host, mds_client):
        self._mds_bucket_name = mds_bucket_name
        self._images_access_host = furl.furl(images_access_host)
        self._mds_client = mds_client

    @classmethod
    def from_settings(cls):
        return cls(
            mds_bucket_name=cars.settings.FINES['mds']['mds_bucket_name'],
            images_access_host=cars.settings.FINES['mds']['images_access_host'],
            mds_client=import_class(cars.settings.MDS['client_class']).from_settings(),
        )

    def add_fine_photo(self, fine_id, b64content):
        photo_id = uuid.uuid4()
        photo = AutocodeFinePhoto(
            id=photo_id,
            fine_id=fine_id,
            url=self.get_photo_url(fine_id, photo_id),
        )

        content = base64.b64decode(b64content.encode('ascii'))
        self._mds_client.put_object(
            key=self.get_photo_key(fine_id, photo_id),
            bucket=self._mds_bucket_name,
            body=content,
        )

        photo.save()
        return photo

    def get_photo_url(self, fine_id, photo_id):
        relative_path = self.get_photo_key(fine_id, photo_id)
        return self._images_access_host.copy().join(relative_path).url

    def get_photo_key(self, fine_id, photo_id):
        return os.path.join(str(fine_id), str(photo_id))
