import datetime
import pytz
from string import digits

from factory import Factory
from factory.fuzzy import FuzzyText, FuzzyFloat, FuzzyDate, FuzzyDateTime

from cars.django.factories import FuzzyDateTimeString, FuzzyBoolean


class FineFeedFactory(Factory):

    class Meta:
        model = dict

    id = FuzzyText(chars=digits, length=6)
    violationDocumentType = 'Sts'
    violationDocumentNumber = FuzzyText(chars=digits, length=10, prefix='777')
    rulingNumber = FuzzyText(chars=digits, length=20, prefix='111')
    violationPlace = FuzzyText(length=20, prefix='МЕСТО НАРУШЕНИЯ ')
    sumToPay = FuzzyFloat(0.01)
    discountDate = FuzzyDateTimeString(
        date_format='%d.%m.%Y',
        date_fuzzy_class=FuzzyDate,
        args=(datetime.datetime(2018, 2, 20, tzinfo=pytz.timezone('Europe/Moscow')),
              datetime.datetime.now(datetime.timezone.utc)))
    odpsName = FuzzyText(length=20, prefix='ОТДЕЛЕНИЕ ДПС ')
    rulingDate = FuzzyDateTimeString(
        date_format='%d.%m.%Y',
        date_fuzzy_class=FuzzyDate,
        args=(datetime.datetime(2018, 2, 20, tzinfo=pytz.timezone('Europe/Moscow')),
              datetime.datetime.now(datetime.timezone.utc)))
    rulingNumber = FuzzyText(chars=digits, length=20)
    odpsCode = FuzzyText(chars=digits, length=5)
    hasPhoto = FuzzyBoolean()
    violationDateWithTime = FuzzyDateTimeString(
        date_format='%d.%m.%Y %H:%M:%S',
        date_fuzzy_class=FuzzyDateTime,
        args=(datetime.datetime(2018, 2, 20, tzinfo=pytz.timezone('Europe/Moscow')),
              datetime.datetime.now(datetime.timezone.utc)))
    articleKoap = FuzzyText(length=20, prefix='СТАТЬЯ КОАП ')


class FineFeedGibddFactory(FineFeedFactory):
    rulingNumber = FuzzyText(chars=digits, length=10, prefix='188101')
    odpsName = '4 СБ ДПС ГИБДД на спецтрассе ГУ МВД России по г. Москве'


class FineFeedMadiFactory(FineFeedFactory):
    rulingNumber = FuzzyText(chars=digits, length=25, prefix='03560430101')
    odpsName = 'МАДИ'


class FineFeedAmppFactory(FineFeedFactory):
    rulingNumber = FuzzyText(chars=digits, length=25, prefix='035543101')
    odpsName = 'ГКУ "АМПП"'
