# Generated by Django 2.0.3 on 2018-04-12 20:16

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('carsharing', '0042_removing_autocodefine'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AutocodeFine',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('ruling_number', models.CharField(max_length=64, unique=True)),
                ('autocode_id', models.BigIntegerField(unique=True)),
                ('autocode_payment_confirmation_id', models.BigIntegerField(null=True, unique=True)),
                ('violation_time', models.DateTimeField(null=True)),
                ('ruling_date', models.DateField()),
                ('discount_date', models.DateField(null=True)),
                ('article_koap', models.TextField()),
                ('violation_place', models.TextField()),
                ('sum_to_pay', models.DecimalField(decimal_places=2, max_digits=9)),
                ('odps_code', models.CharField(max_length=16)),
                ('odps_name', models.TextField()),
                ('violation_document_number', models.CharField(max_length=16)),
                ('violation_document_type', models.CharField(choices=[
                 ('DriverLicense', 'DRIVER_LICENSE'), ('Sts', 'STS')], max_length=13)),
                ('has_photo', models.BooleanField()),
                ('fine_information_received_at', models.DateTimeField()),
                ('payment_confirmation_received_at', models.DateTimeField(null=True)),
                ('car', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                          related_name='autocode_fines', to='carsharing.Car')),
                ('order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE,
                                            related_name='autocode_fines', to='orders.Order')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE,
                                           related_name='autocode_fines', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'autocode_fine',
            },
        ),
    ]
