from django.db import models

from .fine import AutocodeFine


class AutocodeFineReport(models.Model):

    fine = models.OneToOneField(
        AutocodeFine,
        related_name='reports',
        on_delete=models.CASCADE,
        primary_key=True,
    )
    reported_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = 'autocode_fine_report'
