from rest_framework.response import Response

from cars.drive.serializers.order import OrderSerializer
from cars.orders.models import Order
from .base import HeadUnitAPIView


class CarStateView(HeadUnitAPIView):
    """
    A stub for head app demo.
    """

    serializer_class = OrderSerializer
    DEMO_USER_ID = 'c3a6b6ce-b533-4bb5-9045-c055925a54f7'  # kozhuhar-kirill-dev

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        latest_order_item = (
            Order.objects
            .filter(user_id=self.DEMO_USER_ID)
            .latest('created_at')
        )

        if latest_order_item.completed_at is not None:
            return Response(None)

        return Response(
            OrderSerializer(latest_order_item).data
        )
