# coding: utf-8
import logging

import django_idm_api.hooks
from django.conf import settings

from cars.users.models.user import User


LOGGER = logging.getLogger(__name__)


class CarsharingIdmHooks(django_idm_api.hooks.AuthHooks):  # pylint: disable=abstract-method

    def add_role(self, login, role, fields):
        try:
            userinfo = settings.YAUTH_BLACKBOX_INSTANCE.userinfo(
                login,
                userip='0.0.0.0',  # Request context is not available in the hook.
                by_login=True,
            )
            uid = int(userinfo['uid'])
            user = User.objects.filter(uid=uid).first()
            if not user:
                LOGGER.info('creating a new user from idm request: %s', userinfo)
                User.objects.create(uid=uid, username=login, email=userinfo['default_email'])
            elif user.username != login:
                user.username = login
                user.save()
        except Exception:
            LOGGER.exception('failed to create user from idm request')

        return super().add_role(login, role, fields)

    def info_impl(self, **kwargs):
        roles = {
            'superuser': 'суперпользователь',
        }
        roles.update(
            ('group-{}'.format(group.pk), group.name) for group in self.get_group_queryset(),
        )
        return roles

    def _get_or_create_user(self, login):
        user = User.objects.filter(username=login).order_by('-uid').first()

        # User should have already been created in add_role().
        if user is None:
            raise NotImplementedError

        return user
