import collections

from cars.core.util import datetime_helper
from cars.users.models import User

from .modification_helper import CategoryTreeModificationHelper
from .selection_helper import CategoryTreeSelectionHelper

import cars.settings


class TreeUploadingHelper(object):
    def __init__(self):
        self._selection_helper = CategoryTreeSelectionHelper()
        self._modification_helper = CategoryTreeModificationHelper(self._selection_helper.build_tree())

        self._default_performer_id = cars.settings.REQUEST_AGGREGATOR['common']['default_performer_id']

    def _get_default_performer(self):
        return User.objects.get(id=self._default_performer_id)

    def upload_tree(self, tree, direction, performer=None):
        # {"root": [{"child_a": ["child_a_1"]}, "child_b"]}
        performed_at = datetime_helper.utc_now()
        performed_by = performer or self._get_default_performer()

        nodes_to_process = collections.deque([(tree, None)])

        while nodes_to_process:
            node, parent_node_id = nodes_to_process.popleft()

            if isinstance(node, collections.Mapping):
                node_label, children = next(iter(node.items()))
            elif isinstance(node, list):
                nodes_to_process.extend([(child, parent_node_id) for child in node])
                continue
            else:
                node_label, children = node, []

            node_labels = node_label.split(';')

            labels = {'ru': node_labels[0]}

            if len(node_labels) > 1:
                labels['en'] = node_labels[1]

            if False:
                node_id = node_labels[0]
                print(parent_node_id, labels)
            else:
                node_id = self._modification_helper.add_node(
                    parent_id=parent_node_id,
                    meta_info={'labels': labels, 'call_direction': direction},
                    performed_at=performed_at,
                    performed_by=performed_by,
                )

            for child in children:
                nodes_to_process.append((child, node_id))
