# Generated by Django 2.0.3 on 2018-12-17 18:18

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('knowledge_base', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='RequestCategoryTreeEdge',
            fields=[
                ('edge_id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
            options={
                'db_table': 'request_category_tree_edge',
            },
        ),
        migrations.CreateModel(
            name='RequestCategoryTreeEdgeHistory',
            fields=[
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_action', models.CharField(choices=[('a', 'ADD'), ('m', 'MODIFY'), ('r', 'REMOVE')], max_length=1)),
                ('history_performed_at', models.DateTimeField()),
                ('edge_id', models.UUIDField()),
                ('parent_id', models.UUIDField()),
                ('child_id', models.UUIDField()),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField()),
                ('history_performed_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'request_category_tree_edge_history',
            },
        ),
        migrations.CreateModel(
            name='RequestCategoryTreeNode',
            fields=[
                ('category_id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
            options={
                'db_table': 'request_category_tree_node',
            },
        ),
        migrations.CreateModel(
            name='RequestCategoryTreeNodeHistory',
            fields=[
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_action', models.CharField(choices=[('a', 'ADD'), ('m', 'MODIFY'), ('r', 'REMOVE')], max_length=1)),
                ('history_performed_at', models.DateTimeField()),
                ('category_id', models.UUIDField()),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField()),
                ('history_performed_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'request_category_tree_node_history',
            },
        ),
        migrations.AddField(
            model_name='requestcategorytreeedge',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='request_category_tree_edge_child', to='knowledge_base.RequestCategoryTreeNode'),
        ),
        migrations.AddField(
            model_name='requestcategorytreeedge',
            name='parent',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='request_category_tree_edge_parent', to='knowledge_base.RequestCategoryTreeNode'),
        ),
        migrations.AddIndex(
            model_name='requestcategorytreenodehistory',
            index=models.Index(fields=['category_id'], name='request_category_tree_node_history_category_id_idx'),
        ),
        migrations.AddIndex(
            model_name='requestcategorytreeedgehistory',
            index=models.Index(fields=['edge_id'], name='request_category_tree_edge_history_edge_id_idx'),
        ),
    ]
