from cars.django.serializers import BaseSerializer, TimestampField
from rest_framework.serializers import BooleanField, CharField


class TreeViewArgumentsSerializer(BaseSerializer):
    on_date = TimestampField(
        required=False,
    )

    filter = CharField(required=False, default='', allow_blank=True)

    enabled_only = BooleanField(required=False, default=False)

    origin = CharField(required=False)


class TreeHistoryViewArgumentsSerializer(BaseSerializer):
    since = TimestampField(
        required=True,
    )
