from django.conf.urls import url

from . import views


app_name = 'knowledge_base'

urlpatterns = [
    url(
        r'^categories/$',
        views.AllCategoriesAPIView.as_view(),
        name='categories'
    ),
    url(
        r'^categories/tree/$',
        views.CategoriesTreeAPIView.as_view(),
        name='category-tree'
    ),
    url(
        r'^categories/tree/history/$',
        views.CategoriesTreeHistoryAPIView.as_view(),
        name='category-tree-history'
    ),
    url(
        r'^categories/tree/modify/$',
        views.CategoriesTreeActionPerformAPIView.as_view(),
        name='category-tree-modify'
    ),
]
