import re

import cars.settings
from cars.core.util import import_class
from .base import BaseOrderItemManager


class CarsharingBaseOrderItemManager(BaseOrderItemManager):

    _telematics_proxy = import_class(cars.settings.TELEMATICS['proxy_class']).from_settings()

    @classmethod
    def get_item_request_class(cls):
        raise NotImplementedError

    @classmethod
    def get_item_type(cls):
        raise NotImplementedError

    @classmethod
    def _get_tariff_picker(cls):
        raise NotImplementedError

    @classmethod
    def try_stop_warming(cls, car):
        if car.get_telematics_state() is None:
            return

        if not car.telematics_state.engine_on:
            return

        m = re.match(r'.*rc(\d+).*', car.telematics_state.mcu_firmware)
        if m is None:
            return

        try:
            fw_version_string = m.group(1)
            fw_version = int(fw_version_string)
        except ValueError:
            return

        if fw_version < 20:
            return

        response = cls._telematics_proxy.stop_warmup(car.imei)
        response.raise_for_status()

        return response
