from ...models.order_item import OrderItem
from .carsharing_acceptance import CarsharingAcceptanceManager
from .carsharing_parking import CarsharingParkingManager
from .carsharing_reservation import CarsharingReservationManager
from .carsharing_reservation_paid import CarsharingReservationPaidManager
from .carsharing_ride import CarsharingRideManager


class OrderItemManagerFactory(object):

    @classmethod
    def get_class_from_item_type(cls, order_item_type):
        if order_item_type is OrderItem.Type.CARSHARING_ACCEPTANCE:
            controller_class = CarsharingAcceptanceManager
        elif order_item_type is OrderItem.Type.CARSHARING_PARKING:
            controller_class = CarsharingParkingManager
        elif order_item_type is OrderItem.Type.CARSHARING_RESERVATION:
            controller_class = CarsharingReservationManager
        elif order_item_type is OrderItem.Type.CARSHARING_RESERVATION_PAID:
            controller_class = CarsharingReservationPaidManager
        elif order_item_type is OrderItem.Type.CARSHARING_RIDE:
            controller_class = CarsharingRideManager
        else:
            raise RuntimeError('unreachable: {}'.format(order_item_type))
        return controller_class

    @classmethod
    def build_from_item(cls, order_item):
        type_ = order_item.get_type()
        controller_class = cls.get_class_from_item_type(type_)
        controller = controller_class(order_item)
        return controller
