import enum

from django.utils.translation import gettext as _

from cars.core.sms import SmsNotifier


class OrderOperationNotifier:

    class MessageCode(enum.Enum):
        ORDER_TERMINATED_ON_DEBT = 'orders.order_items.carsharing_parking.terminate_on_debt.sms'

    def __init__(self, sms_notifier):
        self._sms = sms_notifier

    @classmethod
    def from_settings(cls):
        return cls(
            sms_notifier=SmsNotifier.from_settings(),
        )

    def notify_order_terminating_for_debt(self, user, debt):
        text = _(self.MessageCode.ORDER_TERMINATED_ON_DEBT.value).format(debt=debt)
        self._sms.send(phone=user.phone.as_e164, text=text)
