import logging

from ..serializers.order import OrderSerializer


LOGGER = logging.getLogger(__name__)


class OrderUpdater(object):

    def __init__(self, order, push_client):
        self._order = order
        self._push_client = push_client

    def update_payment_status(self, payment_status):
        prev_payment_status = self._order.payment_status
        self._order.payment_status = payment_status.value
        self._order.save(update_fields=['payment_status'])

        self._log(
            subtype='update.payment_status',
            order=self._order,
            extra={
                'old': prev_payment_status,
                'new': self._order.payment_status,
            },
        )

    def _log(self, subtype, order, extra=None):
        try:
            full_type = 'order.{}'.format(subtype)

            data = {
                'order': OrderSerializer(order).data,
            }
            if extra:
                data.update(extra)

            self._push_client.log(type_=full_type, data=data)
        except Exception:
            LOGGER.exception('failed to log order state')
