import cars.settings
from cars.core.push_client import CarsharingPushClientLogger
from cars.django.lock import UwsgiLock


class OrdersPushClientLogger(CarsharingPushClientLogger):

    def __init__(self, filename):
        super().__init__(filename=filename, lock=UwsgiLock())

    def log(self, type_, data):
        type_ = 'orders.{}'.format(type_)
        super().log(type_=type_, data=data)


PUSH_CLIENT = OrdersPushClientLogger(filename=cars.settings.ORDERS['push_client']['filename'])
