from cars.core.daemons import CarsharingDaemon
from ..core.carsharing_free_parking_tracker import CarsharingFreeParkingTracker
from ..core.carsharing_reservation_terminator import CarsharingReservationTerminator


class OrdersCarsharingDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */5'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._free_parking_tracker = CarsharingFreeParkingTracker.from_settings()
        self._reservation_terminator = CarsharingReservationTerminator.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'orders/locks/carsharing.lock'

    def get_solomon_sensor_prefix(self):
        return 'orders.carsharing'

    def get_solomon_service(self):
        return 'orders'

    def _do_tick(self):
        self._free_parking_tracker.track_all()
        self._reservation_terminator.process_ongoing_reservations()
