from cars.core.daemons import CarsharingDaemon
from ..core.order_debt_terminator import OrderDebtTerminator


class OrderDebtTerminatorDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */5'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.order_debt_terminator = OrderDebtTerminator.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'orders/locks/debt_terminator.lock'

    def get_solomon_sensor_prefix(self):
        return 'orders.debt_terminator'

    def get_solomon_service(self):
        return 'orders'

    def _do_tick(self):
        self.order_debt_terminator.process_all()
