from cars.core.daemons import CarsharingDaemon
from ..core.order_export_builder import OrderExportBuilder, OrderExportYtManager


class OrderExportBuilderDaemon(CarsharingDaemon):

    tick_interval = '42 * * * *'

    def get_distributed_lock_relative_path(self):
        return 'orders/locks/export_builder.lock'

    def get_solomon_sensor_prefix(self):
        return 'orders.export_builder'

    def get_solomon_service(self):
        return 'orders'

    def _do_tick(self):
        export_builder = OrderExportBuilder.from_settings()

        yt_manager = OrderExportYtManager.from_settings()
        yt_manager.setup()

        export_builder.update_yt_export(yt_manager=yt_manager)
