import logging

from cars.core.daemons import CarsharingDaemon
from ..core.renaissance import RenaissanceClient


LOGGER = logging.getLogger(__name__)


class InsuranceReportDaemon(CarsharingDaemon):

    tick_interval = '*/5 * * * *'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._renaissance_client = RenaissanceClient.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'orders/locks/insurance_report.lock'

    def get_solomon_sensor_prefix(self):
        return 'orders.insurance_report'

    def get_solomon_service(self):
        return 'orders'

    def _do_tick(self):
        self._renaissance_client.report_new_rides()
