import copy
import os

import kubiki

import cars.settings
from cars.core.daemons import CarsharingDaemon
from ..core.order_debt_manager import DebtRetryPolicy, OrderDebtManager
from ..core.order_payment_processor import OrderPaymentProcessor
from ..core.push_client import PUSH_CLIENT


class OrdersPaymentProcessorDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.debt_manager = OrderDebtManager.from_settings(push_client=PUSH_CLIENT)
        self.payment_processor = OrderPaymentProcessor.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'orders/locks/payment_processor.lock'

    def get_solomon_sensor_prefix(self):
        return 'orders.payment_processor'

    def get_solomon_service(self):
        return 'orders'

    def get_distributed_lock(self):
        locks_config = copy.deepcopy(cars.settings.YT['locks'])
        base_dir = locks_config.pop('base_dir')
        locks_config['path'] = os.path.join(base_dir, self.get_distributed_lock_relative_path())

        locks_config['ttl'] = 60

        return kubiki.distributed_lock.YtLock(**locks_config)

    def _do_tick(self):
        self.payment_processor.finalize_all_orders_payment_statuses()
        self.payment_processor.make_payments_for_unpaid_orders()

        self.debt_manager.mark_debtors()
        self.debt_manager.unmark_debtors()

        debt_retry_policy = DebtRetryPolicy.from_settings()
        self.debt_manager.retry_all_debts(policy=debt_retry_policy)

        self.debt_manager.update_old_backend_debt_records()
