import datetime

import pytz
from factory import SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime

from cars.users.factories.user import UserFactory
from ..models.order import Order


class OrderFactory(DjangoModelFactory):

    class Meta:
        model = Order

    user = SubFactory(UserFactory)
    created_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    completed_at = None
