import datetime

import pytz
from factory import SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime

from ..models.order_item import OrderItem
from .order import OrderFactory


class OrderItemFactory(DjangoModelFactory):

    class Meta:
        model = OrderItem

    order = SubFactory(OrderFactory)

    started_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    finished_at = None
