class IOrderItemRequestImpl:

    class Error(Exception):
        pass

    class NotAuthorizedError(Error):
        pass

    class ParseError(Error):
        pass

    class PrepareError(Error):
        pass

    class MaterializeError(Error):
        pass

    @classmethod
    def from_dict(cls, user, data):
        raise NotImplementedError

    def prepare(self):
        raise NotImplementedError

    def materialize(self, order):
        raise NotImplementedError

    def get_message(self):
        return None
