# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-12-27 18:42
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('carsharing', '0003_add_reservation'),
    ]

    operations = [
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField()),
                ('completed_at', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, related_name='orders', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'order',
            },
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('type', models.CharField(choices=[('carsharing_ride', 'CARSHARING_PARKING'), ('carsharing_reservation', 'CARSHARING_RESERVATION')], max_length=32)),
                ('started_at', models.DateTimeField()),
                ('finished_at', models.DateTimeField(null=True)),
                ('carsharing_reservation', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_item', to='carsharing.CarsharingReservation')),
                ('order', models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, related_name='items', to='orders.Order')),
            ],
            options={
                'db_table': 'order_item',
            },
        ),
        migrations.AddIndex(
            model_name='orderitem',
            index=models.Index(fields=['order'], name='order_item_order_idx'),
        ),
        migrations.AddIndex(
            model_name='order',
            index=models.Index(fields=['user'], name='order_user_idx'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='OrderItem',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (type = 'carsharing_reservation' AND carsharing_reservation_id IS NOT NULL)\n                  AND (\n                    CASE WHEN carsharing_reservation_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
