# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-01-05 14:26
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        ('carsharing', '0007_add_parking_and_ride'),
        ('orders', '0001_add_order_and_order_item'),
    ]

    operations = [
        migrations.AddField(
            model_name='orderitem',
            name='carsharing_parking',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_item', to='carsharing.CarsharingParking'),
        ),
        migrations.AddField(
            model_name='orderitem',
            name='carsharing_ride',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_item', to='carsharing.CarsharingRide'),
        ),
        migrations.AlterField(
            model_name='orderitem',
            name='type',
            field=models.CharField(choices=[('carsharing_parking', 'CARSHARING_PARKING'), ('carsharing_reservation', 'CARSHARING_RESERVATION'), ('carsharing_ride', 'CARSHARING_RIDE')], max_length=32),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='orderitem',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (type = 'carsharing_parking' AND carsharing_parking_id IS NOT NULL)\n                  OR\n                  (type = 'carsharing_reservation' AND carsharing_reservation_id IS NOT NULL)\n                  OR\n                  (type = 'carsharing_ride' AND carsharing_ride_id IS NOT NULL)\n                  AND (\n                    CASE WHEN carsharing_parking_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_reservation_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_ride_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
