# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-01-11 21:49
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        ('orders', '0002_more_order_item_types'),
    ]

    operations = [
        migrations.CreateModel(
            name='FixOrderItemTariffParams',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cost', models.DecimalField(decimal_places=2, max_digits=10)),
            ],
            options={
                'db_table': 'order_item_tariff_fix_params',
            },
        ),
        migrations.CreateModel(
            name='OrderItemTariff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('fix', 'FIX'), ('per_minute', 'PER_MINUTE')], max_length=16)),
            ],
            options={
                'db_table': 'order_item_tariff',
            },
        ),
        migrations.CreateModel(
            name='PerMinuteOrderItemTariffParams',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cost_per_minute', models.DecimalField(decimal_places=2, max_digits=10)),
            ],
            options={
                'db_table': 'order_item_tariff_per_minute_params',
            },
        ),
        migrations.AddField(
            model_name='orderitemtariff',
            name='fix_params',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_item', to='orders.FixOrderItemTariffParams'),
        ),
        migrations.AddField(
            model_name='orderitemtariff',
            name='per_minute_params',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_item', to='orders.PerMinuteOrderItemTariffParams'),
        ),
        migrations.AddField(
            model_name='orderitem',
            name='tariff',
            field=models.OneToOneField(db_index=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_item', to='orders.OrderItemTariff'),
        ),
        migrations.AddIndex(
            model_name='orderitem',
            index=models.Index(fields=['tariff'], name='order_item_tariff_idx'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='OrderItemTariff',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (type = 'fix' AND fix_params_id IS NOT NULL)\n                  OR\n                  (type = 'per_minute' AND per_minute_params_id IS NOT NULL)\n                  AND (\n                    CASE WHEN fix_params_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN per_minute_params_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
