# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-02-03 22:34
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        ('billing', '0001_initial'),
        ('orders', '0004_carsharing_acceptance_order_item'),
    ]

    operations = [
        migrations.CreateModel(
            name='OrderItemPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_method', models.CharField(choices=[('card', 'CARD')], max_length=16)),
            ],
            options={
                'db_table': 'order_item_payment',
            },
        ),
        migrations.CreateModel(
            name='OrderPaymentMethod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('card', 'CARD'), ('free', 'FREE')], max_length=16)),
                ('card_paymethod_id', models.CharField(max_length=32, null=True)),
            ],
            options={
                'db_table': 'order_payment_method',
            },
        ),
        migrations.AddField(
            model_name='order',
            name='paid_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='orderitempayment',
            name='card_payment',
            field=models.ForeignKey(db_index=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='billing.CardPayment'),
        ),
        migrations.AddField(
            model_name='orderitempayment',
            name='order_item',
            field=models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, related_name='payments', to='orders.OrderItem'),
        ),
        migrations.AddField(
            model_name='order',
            name='payment_method',
            field=models.OneToOneField(db_index=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order', to='orders.OrderPaymentMethod'),
        ),
        migrations.AddIndex(
            model_name='order',
            index=models.Index(fields=['payment_method'], name='order_payment_method_idx'),
        ),
        migrations.AddIndex(
            model_name='order',
            index=models.Index(fields=['paid_at'], name='order_paid_at_idx'),
        ),
        migrations.AddIndex(
            model_name='orderitempayment',
            index=models.Index(fields=['order_item'], name='order_item_payment_order_item_idx'),
        ),
        migrations.AddIndex(
            model_name='orderitempayment',
            index=models.Index(fields=['card_payment'], name='order_item_payment_card_payment_idx'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='OrderItemPayment',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (payment_method = 'card' AND card_payment_id IS NOT NULL)\n                  AND (\n                    CASE WHEN card_payment_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
