# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-02-13 14:08
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        ('carsharing', '0023_carsharing_reservation_paid'),
        ('orders', '0007_order_item_payment_amount'),
    ]

    operations = [
        migrations.AddField(
            model_name='orderitem',
            name='carsharing_reservation_paid',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_item', to='carsharing.CarsharingReservationPaid'),
        ),
        migrations.AlterField(
            model_name='orderitem',
            name='type',
            field=models.CharField(choices=[('carsharing_acceptance', 'CARSHARING_ACCEPTANCE'), ('carsharing_parking', 'CARSHARING_PARKING'), ('carsharing_reservation', 'CARSHARING_RESERVATION'), ('carsharing_reservation_paid', 'CARSHARING_RESERVATION_PAID'), ('carsharing_ride', 'CARSHARING_RIDE')], max_length=32),
        ),
        migrations.AlterField(
            model_name='orderitempayment',
            name='amount',
            field=models.DecimalField(decimal_places=2, max_digits=10),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='orderitem',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (type = 'carsharing_acceptance' AND carsharing_acceptance_id IS NOT NULL)\n                  OR\n                  (type = 'carsharing_parking' AND carsharing_parking_id IS NOT NULL)\n                  OR\n                  (type = 'carsharing_reservation' AND carsharing_reservation_id IS NOT NULL)\n                  OR\n                  (type = 'carsharing_reservation_paid' AND carsharing_reservation_paid_id IS NOT NULL)\n                  OR\n                  (type = 'carsharing_ride' AND carsharing_ride_id IS NOT NULL)\n                  AND (\n                    CASE WHEN carsharing_acceptance_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_parking_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_reservation_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_reservation_paid_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_ride_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
