# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-02-19 00:18
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        ('billing', '0005_bonus_payment'),
        ('orders', '0008_order_item_carsharing_reservation_paid'),
    ]

    operations = [
        migrations.AddField(
            model_name='orderitempayment',
            name='bonus_payment',
            field=models.ForeignKey(db_index=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='billing.BonusPayment'),
        ),
        migrations.AlterField(
            model_name='orderitempayment',
            name='payment_method',
            field=models.CharField(choices=[('bonus', 'BONUS'), ('card', 'CARD')], max_length=16),
        ),
        migrations.AddIndex(
            model_name='orderitempayment',
            index=models.Index(fields=['bonus_payment'], name='order_item_payment_bonus_payment_idx'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='orderitem',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (\n                    (type = 'carsharing_acceptance' AND carsharing_acceptance_id IS NOT NULL)\n                    OR\n                    (type = 'carsharing_parking' AND carsharing_parking_id IS NOT NULL)\n                    OR\n                    (type = 'carsharing_reservation' AND carsharing_reservation_id IS NOT NULL)\n                    OR\n                    (type = 'carsharing_reservation_paid' AND carsharing_reservation_paid_id IS NOT NULL)\n                    OR\n                    (type = 'carsharing_ride' AND carsharing_ride_id IS NOT NULL)\n                  )\n                  AND\n                  (\n                    CASE WHEN carsharing_acceptance_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_parking_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_reservation_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_reservation_paid_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN carsharing_ride_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
        django_db_constraints.operations.AlterConstraints(
            name='orderitempayment',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (\n                    (payment_method = 'bonus' AND bonus_payment_id IS NOT NULL)\n                    OR\n                    (payment_method = 'card' AND card_payment_id IS NOT NULL)\n                  )\n                  AND\n                  (\n                    CASE WHEN bonus_payment_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN card_payment_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
