# -*- coding: utf-8 -*-

from base64 import b64decode
from django.db import models
from django.contrib.postgres import fields
from cars.users.models import User
from cars.proto.snapshot_pb2 import TCompiledRidingMeta


class CompiledRide(models.Model):
    class Meta:
        managed = False
        db_table = 'compiled_rides'

    history_event_id = models.BigIntegerField(primary_key=True)
    history_user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        primary_key=True,
    )
    history_action = models.TextField()
    history_timestamp = models.BigIntegerField()
    history_comment = models.TextField(null=True)
    session_id = models.TextField()
    object_id = models.UUIDField()
    price = models.IntegerField()
    duration = models.IntegerField()
    start = models.IntegerField()
    finish = models.IntegerField()
    meta = fields.JSONField()
    meta_proto = models.TextField()

    def get_meta(self):
        meta = TCompiledRidingMeta()
        meta.ParseFromString(b64decode(self.meta_proto))
        return meta
