import enum

from django.db import models


class OrderPaymentMethod(models.Model):

    class Type(enum.Enum):
        CARD = 'card'
        FREE = 'free'

    type = models.CharField(max_length=16, choices=[(x.value, x.name) for x in Type])
    card_paymethod_id = models.CharField(max_length=32, null=True)

    class Meta:
        db_table = 'order_payment_method'

    def __repr__(self):
        return '<OrderPaymentMethod: type={}>'.format(self.type)

    def get_type(self):
        return self.Type(self.type)
