from django.db import models

from .order import Order
from .order_item_tariff import OrderItemTariff


class OrderTariffSnapshotManager(models.Manager):

    def with_related(self):
        return (
            self.get_queryset()
            .select_related(
                'carsharing_reservation_paid',
                'carsharing_ride',
                'carsharing_parking',
            )
        )


class OrderTariffSnapshot(models.Model):

    order = models.OneToOneField(
        Order,
        on_delete=models.CASCADE,
        related_name='tariff_snapshot',
    )

    carsharing_reservation_paid = models.OneToOneField(
        OrderItemTariff,
        null=True,
        on_delete=models.CASCADE,
        related_name='carsharing_reservation_paid_order_tariff_snaphot',
    )

    carsharing_parking = models.OneToOneField(
        OrderItemTariff,
        null=True,
        on_delete=models.CASCADE,
        related_name='carsharing_parking_order_tariff_snaphot',
    )

    carsharing_ride = models.OneToOneField(
        OrderItemTariff,
        null=True,
        on_delete=models.CASCADE,
        related_name='carsharing_ride_order_tariff_snaphot',
    )

    objects = OrderTariffSnapshotManager()

    class Meta:
        db_table = 'order_tariff_snapshot'
