from rest_framework.serializers import ModelSerializer, UUIDField

from cars.django.serializers import TimestampField
from cars.orders.models.order import Order
from .order_item import OrderItemSerializer


class OrderSerializer(ModelSerializer):
    user_id = UUIDField()
    items = OrderItemSerializer(many=True)
    created_at = TimestampField()
    completed_at = TimestampField()

    class Meta:
        model = Order
        fields = [
            'id',
            'user_id',
            'items',
            'created_at',
            'completed_at',
        ]
