from rest_framework.serializers import ModelSerializer

from cars.django.serializers import TimestampField
from cars.orders.models.order_item import OrderItem



class OrderItemSerializer(ModelSerializer):
    started_at = TimestampField()
    finished_at = TimestampField()

    class Meta:
        model = OrderItem
        fields = [
            'id',
            'type',
            'started_at',
            'finished_at',
        ]
