import shapely.geometry
import shapely.wkt

class Region(object):

    def __init__(self, id_, name, shape):
        self.id = id_
        self.name = name
        self.shape = shape

    def contains_ll(self, lon, lat):
        point = shapely.geometry.Point(lon, lat)
        return self.shape.contains(point)


GARDEN_RING = Region(
    id_='garden_ring',
    name='Садовое кольцо',
    shape=shapely.wkt.loads('POLYGON((37.58216857910156 55.75250450441111,37.585601806640625 55.76100487670007,37.596588134765625 55.77027589728756,37.61066436767578 55.77375196166915,37.62989044189453 55.77375196166915,37.64636993408203 55.77027589728756,37.657012939453125 55.764288615285686,37.658042907714844 55.75694811193854,37.655296325683594 55.74999267621858,37.654266357421875 55.7418764335707,37.64019012451172 55.73221203848704,37.61993408203125 55.72911892663445,37.612037658691406 55.729892227572755,37.585601806640625 55.73917064416214,37.581138610839844 55.74728744959194,37.58216857910156 55.75250450441111))'),  # pylint: disable=line-too-long
)

THIRD_RING = Region(
    id_='third_ring',
    name='Третье кольцо',
    shape=shapely.wkt.loads('POLYGON((37.57392883300781 55.79216811861972,37.62062072753906 55.79332619035845,37.63572692871094 55.79216811861972,37.651519775390625 55.79448422766427,37.665252685546875 55.78406065228099,37.68035888671875 55.777110052371356,37.6885986328125 55.77131693866828,37.694091796875 55.76745438449046,37.694091796875 55.75586442552934,37.6995849609375 55.746589977937205,37.69752502441406 55.73924614306264,37.71331787109375 55.72339421091869,37.67555236816406 55.71140432997232,37.65632629394531 55.703280061309556,37.61924743652344 55.705601453297064,37.6116943359375 55.7005715963641,37.58628845214844 55.706375219982036,37.574615478515625 55.71449884515052,37.552642822265625 55.72339421091869,37.54234313964844 55.73151429735617,37.533416748046875 55.7419519272367,37.52998352050781 55.753159606084814,37.53822326660156 55.77170317303702,37.552642822265625 55.776723871579065,37.57392883300781 55.79216811861972))'),  # pylint: disable=line-too-long
)

MKAD = Region(
    id_='mkad',
    name='МКАД',
    shape=shapely.wkt.loads('POLYGON((37.40570068359375 55.86867751681321,37.451019287109375 55.8840853004569,37.481231689453125 55.88639594066465,37.529296875 55.907185513142984,37.58697509765625 55.91180390537095,37.629547119140625 55.90025689343537,37.6995849609375 55.89409708127086,37.772369384765625 55.858659178350905,37.835540771484375 55.8278173129374,37.84515380859375 55.75524257516345,37.832794189453125 55.696466221339065,37.8369140625 55.653875501884336,37.764129638671875 55.6065842735233,37.687225341796875 55.57631898214261,37.66937255859375 55.5708842794536,37.59246826171875 55.575542642092294,37.50732421875 55.59805027247056,37.431793212890625 55.6592987142552,37.41119384765625 55.6887259028325,37.38372802734375 55.712715902467856,37.364501953125 55.74905975653018,37.36724853515625 55.79077476792376,37.387847900390625 55.808528719546906,37.393341064453125 55.838614749206684,37.390594482421875 55.85788842990767,37.40570068359375 55.86867751681321))'),  # pylint: disable=line-too-long
)

OUTSKIRTS = Region(
    id_='outskirts',
    name='Вне МКАД',
    shape=shapely.wkt.loads('POLYGON((34.29931640625 57.331154509166275,40.869140625 57.331154509166275,40.869140625 54.16745895810963,34.29931640625 54.16745895810963,34.29931640625 57.331154509166275))'),  # pylint: disable=line-too-long
)

SPB = Region(
    id_='spb',
    name='Санкт-Петербург',
    shape=shapely.wkt.loads('POLYGON((29.5367431640625 60.22996820119634,31.13525390625 60.22996820119634,31.13525390625 59.6327423719599,29.5367431640625 59.6327423719599,29.5367431640625 60.22996820119634))'),  # pylint: disable=line-too-long
)

REGIONS = [
    GARDEN_RING,
    THIRD_RING,
    MKAD,
    OUTSKIRTS,
    SPB,
]

REGIONS_BY_ID = {r.id: r for r in REGIONS}


def get_by_location(lon, lat):
    result = None
    for region in REGIONS:
        if region.contains_ll(lon, lat):
            result = region
            break
    return result
