from rest_framework.serializers import ModelSerializer

from cars.carsharing.models import Car, CarLocation, CarModel, CarTelematicsState


class CarLocationSerializer(ModelSerializer):

    class Meta:
        model = CarLocation
        fields = '__all__'


class CarModelSerializer(ModelSerializer):

    class Meta:
        model = CarModel
        fields = [
            'name',
            'image_large_url',
        ]


class CarTelematicsStateSerializer(ModelSerializer):

    class Meta:
        model = CarTelematicsState
        fields = [
            'fuel_level'
        ]


class CarSerializer(ModelSerializer):

    location = CarLocationSerializer()
    model = CarModelSerializer()
    telematics_state = CarTelematicsStateSerializer()

    class Meta:
        model = Car
        fields = [
            'id',
            'number',
            'location',
            'model',
            'status',
            'telematics_state',  # initially for fuel level
        ]
