from rest_framework.response import Response

from cars.carsharing.models import Car
from ..serializers.carsharing import CarSerializer
from .base import PorscheAdminAPIView


class CarListView(PorscheAdminAPIView):

    def get_queryset(self):
        return (
            Car.objects
            .filter(
                model__manufacturer='Porsche'
            )
            .select_related(
                'location',
                'model',
                'telematics_state',
            )
        )

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        cars_qs = self.get_queryset()
        return Response(
            CarSerializer(cars_qs, many=True).data
        )
