import packaging
import packaging.version
import packaging.specifiers
import packaging.requirements


def fuel_level_extractor_mapper(row):

    sensor = '2107'  # fuel percentage (CAN_FUEL_LEVEL_P)
    sensor_value = None

    if str(row['type']) == 'BLACKBOX_RECORDS':

        for record in (
                r for r in row['data'].get('records', [])
                if r.get('type') == 'record'
        ):
            if record.get('type') != 'record':
                continue
            for subrecord in (
                    sr for sr in record['subrecords']
                    if sr.get('type') == 'custom_parameters'
                    and 'params' in sr
            ):
                if 'params' not in subrecord:
                    continue
                params = subrecord['params']
                if params:
                    sensor_value = params.get(sensor)
    if sensor_value is not None:
        yield {
            'imei': row['imei'],
            'timestamp': row['timestamp'],
            'fuel_percentage': sensor_value,
        }
