import cars.settings
from cars.carsharing.models import Car


class RefuelCarAccessVerifier:

    def __init__(self, refuel_threshold, allow_if_fueled, allow_if_available):
        self._refuel_threshold = refuel_threshold
        self._allow_if_fueled = allow_if_fueled
        self._allow_if_available = allow_if_available

    @classmethod
    def from_settings(cls, allow_if_fueled, allow_if_available):
        return cls(
            refuel_threshold=cars.settings.REFUEL['refuel_threshold'],
            allow_if_fueled=allow_if_fueled,
            allow_if_available=allow_if_available,
        )

    def is_allowed(self, car_id):
        car = Car.objects.filter(id=car_id).first()

        if car is None:
            return False

        car_status = car.status

        if car_status == Car.Status.AVAILABLE.value and not self._allow_if_available:
            # Discard requests when the car is not reserved
            return False

        if car_status not in (
            Car.Status.AVAILABLE.value,
            Car.Status.FUELING.value,
            Car.Status.SERVICE.value,
        ):
            # Don't even consider a car in a different status
            return False

        fuel_level = car.get_telematics_state().fuel_level
        if fuel_level < self._refuel_threshold:
            # Car needs refueling
            return True

        if car_status == Car.Status.FUELING.value:
            # Car in fueling state
            return True

        if self._allow_if_fueled:
            # It's explicitly specified that the view is allowed
            return True

        return False
