import logging
from cars.core.daemons import CarsharingDaemon
from ..core.fuel_level_extractor import FuelLevelExtractor


LOGGER = logging.getLogger(__name__)


class FuelLevelExtractorDaemon(CarsharingDaemon):

    tick_interval = '*/15 * * * *'  # every 15 minutes

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._fuel_level_extractor = FuelLevelExtractor.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'carsharing/locks/fuel_level_exctractor.lock'

    def get_solomon_sensor_prefix(self):
        return 'carsharing.fuel_level_exctractor'

    def get_solomon_service(self):
        return 'carsharing'

    def _do_tick(self):
        LOGGER.info('starting daily fuel level logs extraction')
        self._fuel_level_extractor.extract_fuel_level_for_days(30)
        LOGGER.info('starting current stream fuel level logs extraction')
        self._fuel_level_extractor.extract_fuel_level_current_stream()
